﻿using System;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;

namespace Performance.EntityModels.Entity
{
    [Table("per_attendance_dept")]
    public class per_attendance_dept
    {
        /// <summary>
        /// 自增主键
        /// </summary>
        [Key]
        public int Id { get; set; }

        /// <summary>
        /// 医院Id,可空
        /// </summary>
        public int? HospitalId { get; set; }

        /// <summary>
        /// 绩效Id
        /// </summary>
        public int AllotId { get; set; }

        /// <summary> 
        /// 工号
        /// </summary>
        public string PersonnelNumber { get; set; }

        /// <summary>
        /// 姓名
        /// </summary>
        public string PersonnelName { get; set; }

        /// <summary>
        /// 人员系数
        /// </summary>
        public decimal? PermanentStaff { get; set; }

        /// <summary>
        /// 核算单元编码
        /// </summary>
        public string Code { get; set; }

        /// <summary>
        /// 人员类别
        /// </summary>
        public string UnitType { get; set; }

        /// <summary>
        /// 核算单元
        /// </summary>
        public string AccountingUnit { get; set; }

        /// <summary>
        /// 状态(未提交 = 1,提交 =2,通过 = 3,驳回 = 4)
        /// </summary>
        public int State { get; set; }

        /// <summary>
        /// 提交用户
        /// </summary>
        public string SubmitUser { get; set; }

        /// <summary>
        /// 提交时间
        /// </summary>
        public DateTime? SubmitTime { get; set; }

        /// <summary>
        /// 审核用户
        /// </summary>
        public string AuditUser { get; set; }

        /// <summary>
        /// 审核时间
        /// </summary>
        public DateTime? AuditTime { get; set; }

        /// <summary>
        /// 备注
        /// </summary>
        public string Remarks { get; set; }

        /// <summary>
        /// 01日
        /// </summary>
        public int? Day01 { get; set; }
        public int? Day02 { get; set; }
        public int? Day03 { get; set; }
        public int? Day04 { get; set; }
        public int? Day05 { get; set; }
        public int? Day06 { get; set; }
        public int? Day07 { get; set; }
        public int? Day08 { get; set; }
        public int? Day09 { get; set; }
        public int? Day10 { get; set; }
        public int? Day11 { get; set; }
        public int? Day12 { get; set; }
        public int? Day13 { get; set; }
        public int? Day14 { get; set; }
        public int? Day15 { get; set; }
        public int? Day16 { get; set; }
        public int? Day17 { get; set; }
        public int? Day18 { get; set; }
        public int? Day19 { get; set; }
        public int? Day20 { get; set; }
        public int? Day21 { get; set; }
        public int? Day22 { get; set; }
        public int? Day23 { get; set; }
        public int? Day24 { get; set; }
        public int? Day25 { get; set; }
        public int? Day26 { get; set; }
        public int? Day27 { get; set; }
        public int? Day28 { get; set; }
        public int? Day29 { get; set; }
        public int? Day30 { get; set; }
        public int? Day31 { get; set; }
    }
}