﻿using System;
using System.Linq;
using System.Linq.Expressions;
using Performance.EntityModels;
using Performance.Infrastructure.Models;

namespace Performance.Repository
{
    public partial class PerforExresultgatherRepository : PerforRepository<ex_result_gather>
    {
        public PageList<ex_result_gather> GetGatherForPaging(int pageNumber, int pageSize, Expression<Func<ex_result_gather, bool>> exp)
        {
            IQueryable<ex_result_gather> queryableAuthors = context.Set<ex_result_gather>()
                .Where(exp)
                .OrderBy(w => w.Department)
                .ThenBy(t => t.PersonnelNumber);

            return PageList<ex_result_gather>.Create(queryableAuthors, pageNumber, pageSize);
        }
    }
}
