﻿using System.Linq;
using System.Reflection;
using Microsoft.Extensions.DependencyInjection;
using Performance.Infrastructure;
using Performance.Repository;

namespace Performance.Services
{
    /// <summary>
    /// DI扩展
    /// </summary>
    public static class PerformanceServiceExtensions
    {
        /// <summary>
        /// 自动注入Service
        /// </summary>
        /// <param name="services"></param>
        /// <returns></returns>
        public static IServiceCollection AddPerformanceService(this IServiceCollection services)
        {
            var types = ReflectionHelper.GetClassType<IAutoInjection>(Assembly.GetExecutingAssembly());
            foreach (var type in types)
            {
                services.AddScoped(type);
            }
            return services;
        }

        /// <summary>
        /// 自动注入Repository
        /// </summary>
        /// <param name="services"></param>
        /// <returns></returns>
        public static IServiceCollection AddPerformanceRepoitory(this IServiceCollection services)
        {
            var repository = typeof(PerforRepository<>).Assembly.GetTypes().Where(t => t.IsClass && !t.IsAbstract);
            foreach (var type in repository)
            {
                services.AddScoped(type);
            }
            return services;
        }
    }
}
